#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Cheap Lightning FlashesMod01.fsh   by   gehtsiegarnixan 
//https://www.shadertoy.com/view/fddBDM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
This is a variant of Shane's Cellular Tiling 
(https://www.shadertoy.com/view/4scXz2, https://www.shadertoy.com/view/MdKXDD).
His versions are pretty extensively commented so give it a read.

This is trying to emulate quasi random flashes of lightning to be used with a
lightning map. This works by moving two differently angled square grids over 
each other. You can clearly see it if you increase the bias to like 0.8. 

I also have a slightly worse tiling function sflashyTiling, that doesn't produce
perfectly round flashes, but they are a bit faster. Its bias works a bit
different so adjust it seperatly. I can't tell them appart in my clouds, so I 
would recomend trying the cheaper variant. 

I changed a number of things to make it simpler and easier to understand. 
You can also select a number of parameters with the mouse.
- GridRes controls the size of the first grid sample
- Degree is controlled by the y-axis of the mouse. It selects the degree of 
      rotation of each grid is offset to each other. You should avoid multiple 
      of 45 degrees and a few degrees around it.
- Scale selects the size difference for each grid layer. Note that values 
greater than about +-10% will make the edges rounded.
- Bias controls the size of the flashes and a bit their number. 
- Offset controls how much the grids are offset from each other or with iTime
the speed of the flashes. 

If you want see if this is faster than a texture lookup see the 
here (https://www.shadertoy.com/view/sd3fDM).
*/

// Text on Screen from Piperoman https://www.shadertoy.com/view/XllSWl
float DigitBin(const in int x) {
    return x==0?480599.0:x==1?139810.0:x==2?476951.0:x==3?476999.0:x==4?350020.0:x==5?464711.0:x==6?464727.0:x==7?476228.0:x==8?481111.0:x==9?481095.0:0.0;
}

float PrintValue(const in vec2 fragCoord, const in vec2 vPixelCoords, const in vec2 vFontSize, const in float fValue, const in float fMaxDigits, const in float fDecimalPlaces) {
    vec2 vStringCharCoords = (fragCoord.xy - vPixelCoords) / vFontSize;
    if ((vStringCharCoords.y < 0.0) || (vStringCharCoords.y >= 1.0)) return 0.0;
	float fLog10Value = log2(abs(fValue)) / log2(10.0);
	float fBiggestIndex = max(floor(fLog10Value), 0.0);
	float fDigitIndex = fMaxDigits - floor(vStringCharCoords.x);
	float fCharBin = 0.0;
	if(fDigitIndex > (-fDecimalPlaces - 1.01)) 
    {
		if(fDigitIndex > fBiggestIndex) 
        {
			if((fValue < 0.0) && (fDigitIndex < (fBiggestIndex+1.5))) fCharBin = 1792.0;
		} 
        else 
        {		
			if(fDigitIndex == -1.0) 
            {
				if(fDecimalPlaces > 0.0) fCharBin = 2.0;
			} 
            else 
            {
				if(fDigitIndex < 0.0) fDigitIndex += 1.0;
				float fDigitValue = (abs(fValue / (pow(10.0, fDigitIndex))));
                float kFix = 0.0001;
                fCharBin = DigitBin(int(floor(mod(kFix+fDigitValue, 10.0))));
			}		
		}
	}
    return floor(mod((fCharBin / pow(2.0, floor(fract(vStringCharCoords.x) * 4.0) + (floor(vStringCharCoords.y * 5.0) * 4.0))), 2.0));
}

// makes YlGnBu_r colormap with polynimal 6 from https://www.shadertoy.com/view/Nd3fR2
vec3 YlGnBu_r(float t) {
    const vec3 c0 = vec3(0.016999,0.127718,0.329492);
    const vec3 c1 = vec3(1.571728,0.025897,2.853610);
    const vec3 c2 = vec3(-4.414197,5.924816,-11.635781);
    const vec3 c3 = vec3(-12.438137,-8.086194,34.584365);
    const vec3 c4 = vec3(67.131044,-2.929808,-58.635788);
    const vec3 c5 = vec3(-82.372983,11.898509,47.184502);
    const vec3 c6 = vec3(31.515446,-5.975157,-13.820580);
    return c0+t*(c1+t*(c2+t*(c3+t*(c4+t*(c5+t*c6)))));
}

// creates a sphere grid of the squared distance to the center
float sphereGrid(vec2 uv) {
    vec2 squaregrid = fract(uv) - .5; //rectangular grid with center in the middle
    float spheregrid = dot(squaregrid, squaregrid); //squared distance form scenter
    return spheregrid;
}

#define pi              3.1415926536
// makes a tiling flashing pattern https://www.desmos.com/calculator/kcmr5ftqqw
float flashyTiling(vec2 uv, float degree, float scale, vec2 offset, float bias) {
    float grid1 = sphereGrid(uv - offset); // first grid
    
    // choose a deg/scale and precalulate this when you picked your paramters
    float rad = (pi* degree)/180.; //degree to radians
    mat2 m = mat2(cos(rad), -sin(rad), sin(rad), cos(rad)); // rotation matric
    m *= scale; // this make the rmatrix also scale
    
    uv *= m; //each iteration gets rotated and scaled one addional time
    float grid2 = sphereGrid(uv +offset.xy); // blending the voronoi with 
    
    float comb = (-grid1 -grid2 +bias)*(1./bias); // inverting adding bias
    comb = clamp(comb, 0., 1.); //saturate
    return comb; //sqrt for center distance, 1.5 for 0-1 range
}

// sine grid, a bit faster than spheregrid
float bubble(vec2 uv) {
    vec2 d = sin(uv*pi); //remove pi for pi sized grid
    return abs(d.x*d.y);    
}

// makes a faster tiling flashing pattern, but not perfectly spherical anymore 
// https://www.desmos.com/calculator/qsqd4w4sq6
float sflashyTiling(vec2 uv, float degree, float scale, vec2 offset, float bias) {
    float grid1 = bubble(uv - offset); // first grid
    
    // choose a deg/scale and precalulate this when you picked your paramters
    float rad = (pi* degree)/180.; //degree to radians
    mat2 m = mat2(cos(rad), -sin(rad), sin(rad), cos(rad)); // rotation matric
    m *= scale; // this make the rmatrix also scale
    
    uv *= m; //each iteration gets rotated and scaled one addional time
    float grid2 = bubble(uv +offset.xy); // blending the voronoi with 
    
    float comb = (grid1 +grid2 +bias-2.)*(1./bias); // inverting adding bias
    comb = clamp(comb, 0., 1.); //saturate to catch rounding errors
    return comb; //0-1 range
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float gridRes = 4.0; //Hex Grid Size
    float bias = .2; //size and kind of number of the flashes
    vec2 offset = vec2(iTime*.2, iTime*1.); //movement
    
    // mouse controls
    float scale = .93; //default values for preview
    float degree = 55.; // default values for preview
    if(iMouse.x > 0.0)	{
        vec4 mouse = iMouse / iResolution.y;
        scale = .17 * mouse.x +.85;  // value range .85-1.15
        degree = mouse.y  * 90.; // it's a square gird going going larger than 90 is pointless
    }
        
    //UV needs to be offset by a large vector from the 0,0, and avoiding 120/90/60 ... deg
    vec2 offset2 = vec2(379., 769.); // two arbitrary large prime numbers
    vec2 uv = vec2(fragCoord/iResolution.y); // uv scaled and offset
    uv = (uv+offset2)*gridRes;
    
    float vor = flashyTiling(uv, degree, scale, offset, bias); // generating cell Tilling    
    
    vec3 vColour = YlGnBu_r(vor); // applying cosmetic colormap
    
    // Text portion
    float fDigits = 1.0;
	float fDecimalPlaces = 3.0;	
    vec2 vFontSize = vec2(8.0, 15.0); // Multiples of 4x5 work best
    
    if(iMouse.x > 0.0)	{
        // Plot Mouse Pos Point
	    float fDistToPointB = length( vec2(iMouse.x, iMouse.y) - fragCoord.xy) - 4.0;
	    vColour = mix(vColour, vec3(0.0, 1.0, 0.0), (1.0 - clamp(fDistToPointB, 0.0, 1.0)));
        
		// Print Mouse X
		vec2 vPixelCoord2 = iMouse.xy + vec2(-62.0, 6.0);
		float fValue2 = scale;
		fDigits = 1.0;
		float fIsDigit2 = PrintValue(fragCoord, vPixelCoord2, vFontSize, fValue2, fDigits, fDecimalPlaces);
		vColour = mix( vColour, vec3(0.0, 1.0, 0.0), fIsDigit2);
		
		// Print Mouse Y
		vec2 vPixelCoord3 = iMouse.xy + vec2(0.0, 6.0);
		float fValue3 = degree;
		fDigits = 1.0;
		float fIsDigit3 = PrintValue(fragCoord, vPixelCoord3, vFontSize, fValue3, fDigits, fDecimalPlaces);
		vColour = mix( vColour, vec3(0.0, 1.0, 0.0), fIsDigit3);
	}
    
    fragColor = vec4(vColour,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

